/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftpbrowser;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoSort;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FileTransferDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean m_ok = false;
    private boolean m_canceled = false;
    private boolean m_scanning = true;
    private boolean m_deleteOp = false;
    private int m_fileCount = 0;
    private int m_dirCount = 0;
    private JTree m_fileTree;
    private CoFile[] m_baseSrcs;
    private JButton m_okButton;
    private JLabel m_label;
    private Icon m_directoryIcon = null;
    private Icon m_fileIcon = null;
    private JLabel m_fileCntLabel;

    public FileTransferDialog(Frame frame, CoFile coFile, CoFile[] coFileArray) {
        super(frame, coFile == null ? "Delete Files?" : "Transfer Files?", true);
        JComponent jComponent;
        JPanel jPanel;
        if (coFile == null) {
            this.m_deleteOp = true;
        }
        this.m_baseSrcs = coFileArray;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(3, 3));
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.getRootPane().setOpaque(true);
        this.m_directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.m_fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.m_label = new JLabel();
        this.m_label.setText("Preparing the file list...");
        Font font = new Font("Dialog", 1, 14);
        this.m_label.setFont(font);
        container.add((Component)this.m_label, "North");
        this.m_fileTree = new JTree(new DefaultMutableTreeNode());
        this.m_fileTree.setCellRenderer(new FileNodeRenderer());
        this.m_fileTree.putClientProperty("JTree.lineStyle", "Angled");
        JScrollPane jScrollPane = new JScrollPane(this.m_fileTree);
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        container.add((Component)jPanel2, "South");
        this.m_fileCntLabel = new JLabel(" ");
        jPanel2.add((Component)this.m_fileCntLabel, "North");
        if (coFile != null) {
            jPanel = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "Center");
            jPanel.setOpaque(true);
            jComponent = new JLabel("To: ");
            jComponent.setFont(font);
            jPanel.add((Component)jComponent, "West");
            jComponent = new JLabel();
            jComponent.setBorder(BorderFactory.createLoweredBevelBorder());
            ((JLabel)jComponent).setIcon(this.m_directoryIcon);
            ((JLabel)jComponent).setText(coFile.getAbsolutePath());
            jPanel.add((Component)jComponent, "Center");
        }
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.m_okButton = new JButton("Ok");
        this.m_okButton.setActionCommand("OK");
        this.m_okButton.addActionListener(this);
        this.m_okButton.setEnabled(false);
        jPanel.add(this.m_okButton);
        jComponent = new JButton("Cancel");
        ((AbstractButton)jComponent).setActionCommand("CANCEL");
        ((AbstractButton)jComponent).addActionListener(this);
        jPanel.add(jComponent);
        jPanel2.add((Component)jPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
        Runnable runnable = new Runnable(){

            public void run() {
                FileTransferDialog.this.scanFiles();
            }
        };
        new Thread(runnable).start();
    }

    public boolean isOk() {
        return this.m_ok;
    }

    public int getFileCount() {
        return this.m_fileCount;
    }

    public int getDirCount() {
        return this.m_dirCount;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.m_ok = true;
            this.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("CANCEL")) {
            this.m_ok = false;
            this.m_canceled = true;
            if (!this.m_scanning) {
                this.setVisible(false);
            }
        }
    }

    private void scanFiles() {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        CoFile[] coFileArray = CoSort.listSplit(this.m_baseSrcs);
        for (int i = 0; i < coFileArray.length && !this.m_canceled; ++i) {
            if (this.processFile(coFileArray[i], null)) continue;
            this.m_canceled = true;
        }
        if (this.m_canceled) {
            this.setVisible(false);
        } else {
            this.m_scanning = false;
            if (this.m_deleteOp) {
                this.m_label.setText("Delete the following items");
            } else {
                this.m_label.setText("Copy the following items");
            }
            this.m_okButton.setEnabled(true);
            this.m_fileCntLabel.setText(this.m_dirCount + " Directories;    " + this.m_fileCount + " Files");
            this.m_fileTree.expandRow(0);
            this.m_fileTree.setRootVisible(false);
            this.m_fileTree.setShowsRootHandles(true);
            this.pack();
        }
        this.setCursor(cursor);
    }

    private boolean processFile(CoFile coFile, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_fileTree.getModel().getRoot();
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(coFile);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        if (coFile.isDirectory()) {
            CoFile[] coFileArray = coFile.listCoFiles();
            if (coFileArray == null) {
                JOptionPane.showMessageDialog(null, "Unable to read directory: " + coFile.getAbsolutePath(), "File Error", 0);
                return false;
            }
            ++this.m_dirCount;
            coFileArray = CoSort.listSplit(coFileArray);
            for (int i = 0; i < coFileArray.length && !this.m_canceled; ++i) {
                if (this.processFile(coFileArray[i], defaultMutableTreeNode2)) continue;
                return false;
            }
        } else {
            ++this.m_fileCount;
        }
        return true;
    }

    private class FileNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private FileNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = new JLabel(" ");
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                CoFile coFile = (CoFile)defaultMutableTreeNode.getUserObject();
                if (coFile == null) {
                    return jLabel;
                }
                if (coFile.isDirectory()) {
                    jLabel.setIcon(FileTransferDialog.this.m_directoryIcon);
                } else {
                    jLabel.setIcon(FileTransferDialog.this.m_fileIcon);
                }
                if (defaultMutableTreeNode.getLevel() == 1) {
                    jLabel.setText(coFile.getAbsolutePath());
                } else {
                    jLabel.setText(coFile.getName());
                }
            } else {
                jLabel.setIcon(FileTransferDialog.this.m_directoryIcon);
            }
            return jLabel;
        }
    }
}

